/*
 * Use at your own risk.
 *
 * Copyright (C) 2005-2008 Sourcefire, Inc.
 * 
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>
 */


#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"


/* declare detection functions */
int rule15148eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow:established, to_server; */
static FlowFlags rule15148flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_SERVER
};

static RuleOption rule15148option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule15148flow0
    }
};
// content:"RCH0", depth 4, nocase; 
static ContentInfo rule15148content1 = 
{
    (uint8_t *) "RCH0", /* pattern (now in snort content format) */
    4, /* depth */
    0, /* offset */
    CONTENT_NOCASE|CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule15148option1 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule15148content1
    }
};
// content:"RCHE", offset 4, depth 4, nocase, relative; 
static ContentInfo rule15148content2 = 
{
    (uint8_t *) "RCHE", /* pattern (now in snort content format) */
    4, /* depth */
    4, /* offset */
    CONTENT_NOCASE|CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule15148option2 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule15148content2
    }
};

/* references for sid 15148 */
/* reference: bugtraq "10726"; */
static RuleReference rule15148ref1 = 
{
    "bugtraq", /* type */
    "10726" /* value */
};

/* reference: cve "2004-0728"; */
static RuleReference rule15148ref2 = 
{
    "cve", /* type */
    "2004-0728" /* value */
};

static RuleReference *rule15148refs[] =
{
    &rule15148ref1,
    &rule15148ref2,
    NULL
};

/* metadata for sid 15148 */
/* metadata: policy balanced-ips drop, policy security-ips drop; */
static RuleMetaData rule15148policy1 =
{
    "policy balanced-ips drop"
};

static RuleMetaData rule15148policy2 =
{
    "policy security-ips drop"
};

static RuleMetaData *rule15148metadata[] =
{
    &rule15148policy1,
    &rule15148policy2,
    NULL
};

RuleOption *rule15148options[] =
{
    &rule15148option0,
    &rule15148option1,
    &rule15148option2,
    NULL
};

Rule rule15148 = {
   
   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "$HOME_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "2702", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid (HARDCODED!!!) */
       15148, /* sigid */
       3, /* revision */
   
       "attempted-dos", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "SERVER-OTHER Microsoft SMS remote control client message length denial of service attempt",     /* message */
       rule15148refs /* ptr to references */
       ,rule15148metadata
   },
   rule15148options, /* ptr to rule options */
   &rule15148eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
int rule15148eval(void *p) {
    const uint8_t *cursor_normal = 0, *beg_of_payload, *end_of_payload;
    SFSnortPacket *sp = (SFSnortPacket *) p;
    uint16_t data_len;

    if(sp == NULL)
        return RULE_NOMATCH;

    if(sp->payload == NULL)
        return RULE_NOMATCH;
    
    // flow:established, to_server;
    if (checkFlow(p, rule15148options[0]->option_u.flowFlags) > 0 ) {
        // content:"RCH0", depth 4, nocase;
        if (contentMatch(p, rule15148options[1]->option_u.content, &cursor_normal) > 0) {
            // content:"RCHE", offset 4, depth 4, nocase, relative;
            if (contentMatch(p, rule15148options[2]->option_u.content, &cursor_normal) > 0) {
                cursor_normal = cursor_normal - 8;
                data_len = *cursor_normal++;
                data_len |= (*cursor_normal++) << 8;

                if(data_len >= 130)
                   return RULE_MATCH;

                if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &beg_of_payload, &end_of_payload) <= 0)
                   return RULE_NOMATCH;

                // Normally, we'd be nervous about this check with TCP, but given the
                // packet sizes involved, we'll take the false positives from segmentation
                // on such a small packet.
                if(cursor_normal + 6 + data_len != end_of_payload)
                   return RULE_MATCH;
            }
        }
    }
    return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule15148,
    NULL
};
*/
